{{/*
MONGODB HOST
*/}}
{{- define "cells.nosql.scheme" -}}
{{- if .Values.mongodb.enabled -}}
{{- "mongodb" -}}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{- .Values.externalNoSQLDatabase.scheme }}
{{- end -}}
{{- end }}

{{- define "cells.nosql.host" -}}
{{- if .Values.mongodb.enabled -}}
{{- printf "%s-mongodb.%s.svc.%s" .Release.Name .Release.Namespace .Values.clusterDomain }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{- .Values.externalNoSQLDatabase.host }}
{{- end -}}
{{- end }}

{{/*
MONGODB PORT
*/}}
{{- define "cells.nosql.port" -}}
{{- if .Values.mongodb.enabled -}}
{{ .Values.mongodb.service.ports.mongodb | toString }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{ .Values.externalNoSQLDatabase.port | toString }}
{{- end -}}
{{- end }}

{{/*
MONGODB ACTIVATION
*/}}
{{- define "cells.nosql.enabled" -}}
{{- if or .Values.mongodb.enabled .Values.externalNoSQLDatabase.enabled -}}
{{ true }}
{{- end -}}
{{- end -}}

{{- define "cells.nosql.params" -}}
{{- .Values.externalNoSQLDatabase.params | toJson }}
{{- end -}}

{{/*
MONGODB TLS ACTIVATION
*/}}
{{- define "cells.nosql.tls.enabled" -}}
{{- if and .Values.mongodb.enabled .Values.mongodb.tls.enabled -}}
{{- true -}}
{{- else if and .Values.externalNoSQLDatabase.enabled .Values.externalNoSQLDatabase.tls.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS ACTIVATION
*/}}
{{- define "cells.nosql.tls.autoGenerated" -}}
{{- if and .Values.mongodb.enabled .Values.mongodb.tls.autoGenerated -}}
{{- true -}}
{{- else if and .Values.externalNoSQLDatabase.enabled .Values.externalNoSQLDatabase.tls.autoGenerated -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.nosql.tls.client.existingSecret" -}}
{{- if .Values.mongodb.enabled -}}
{{ include "cells.tls.client.secretName" (dict "Values" .Values "Chart" .Chart "Release" .Release "dependency" "nosql") }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{ .Values.externalNoSQLDatabase.tls.client.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.nosql.tls.client.cert" -}}
{{- if .Values.mongodb.enabled -}}
{{ .Values.mongodb.tls.certFilename | default "mongodb-ca-cert" }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{ .Values.externalNoSQLDatabase.tls.client.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.nosql.tls.client.key" -}}
{{-  if .Values.externalNoSQLDatabase.enabled -}}
{{ .Values.externalNoSQLDatabase.tls.client.key }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.nosql.tls.server.existingSecret" -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.nosql.tls.server.cert" -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.nosql.tls.server.key" -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.nosql.tls.ca.existingSecret" -}}
{{- if .Values.mongodb.enabled -}}
{{ include "cells.tls.ca.secretName" (dict "Values" .Values "Chart" .Chart "Release" .Release "dependency" "nosql") }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{ .Values.externalNoSQLDatabase.tls.ca.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CA
*/}}
{{- define "cells.nosql.tls.ca.cert" -}}
{{- if .Values.mongodb.enabled -}}
{{ .Values.mongodb.tls.certCAFilename | default "mongodb-ca-cert" }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{ .Values.externalNoSQLDatabase.tls.ca.cert }}
{{- end -}}
{{- end -}}

{{/*
MONGODB TLS PARAMÈTRES
*/}}
{{- define "cells.nosql.tls.params" -}}
{{- if (include "cells.nosql.tls.enabled" .) -}}
{{- include "cells.urlTLSParamsDict" (dict
  "enabled"         (include "cells.nosql.tls.enabled" .)
  "prefix"          "mongodb"
  "certFilename"    (include "cells.nosql.tls.client.cert" .)
  "certKeyFilename" (include "cells.nosql.tls.client.key" .)
  "caFilename"      (include "cells.nosql.tls.ca.cert" .)
) -}}
{{- else -}}
{{ "{}" -}}
{{- end -}}
{{- end -}}

{{/*
MONGODB AUTH ACTIVÉ
*/}}
{{- define "cells.nosql.auth.enabled" -}}
{{- if and .Values.mongodb.enabled .Values.mongodb.auth.enabled -}}
{{- true -}}
{{- else if and .Values.externalNoSQLDatabase.enabled .Values.externalNoSQLDatabase.auth.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
MONGODB USERNAME
*/}}
{{- define "cells.nosql.auth.user" -}}
{{- if .Values.mongodb.enabled -}}
{{ .Values.mongodb.auth.rootUser }}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{- (include "common.secrets.lookup" (dict "secret" .Values.externalNoSQLDatabase.auth.existingSecret "key" (.Values.externalNoSQLDatabase.auth.existingSecretUserKey | default "") "context" . "defaultValue" .Values.externalNoSQLDatabase.auth.user)) | b64dec -}}
{{- end -}}
{{- end -}}

{{/*
MONGODB PASSWORD
*/}}
{{- define "cells.nosql.auth.password" -}}
{{- if .Values.mongodb.enabled -}}
{{- (include "common.secrets.lookup" (dict "secret" (.Values.mongodb.auth.existingSecret | default "cells-mongodb") "key" "mongodb-root-password" "context" . "defaultValue" .Values.mongodb.auth.rootPassword)) | b64dec -}}
{{- else if .Values.externalNoSQLDatabase.enabled -}}
{{- (include "common.secrets.lookup" (dict "secret" .Values.externalNoSQLDatabase.auth.existingSecret "key" (.Values.externalNoSQLDatabase.auth.existingSecretPasswordKey | default "") "context" . "defaultValue" .Values.externalNoSQLDatabase.auth.password)) | b64dec -}}
{{- end -}}
{{- end -}}

{{/*
MONGODB ENV SECRET
*/}}
{{- define "cells.nosql.auth.envvar" -}}
{{- if .Values.mongodb.enabled -}}
{{ $secret := .Values.mongodb.auth.existingSecret | default "cells-mariadb" }}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "NOSQL_USERNAME" "value" (.Values.mongodb.auth.username | default "root")) }}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "NOSQL_PASSWORD" "value" (dict "secretName" $secret "secretPasswordKey" "password")) }}
{{- else if .Values.externalNoSQLDatabase.auth.enabled -}}
{{- include "cells.auth.envvar" (dict "auth" .Values.externalNoSQLDatabase.auth "prefix" "NOSQL") }}
{{- end -}}
{{- end -}}

{{/*
MONGODB URL UTILISATEUR
*/}}
{{- define "cells.nosql.auth.urlUser" -}}
{{- include "cells.urlUser" (dict
  "enabled"  (include "cells.nosql.auth.enabled" .)
  "user"     (include "cells.nosql.auth.user" .)
  "password" (include "cells.nosql.auth.password" .)
) -}}
{{- end -}}

{{/*
MONGODB URL COMPLÈTE
*/}}
{{- define "cells.nosql.url" -}}
{{- $path := .path -}}
{{- $scheme := (.scheme | default (include "cells.nosql.scheme" .context)) -}}
{{- $authParams := (.authParams | default (include "cells.nosql.auth.urlUser" .context)) -}}
{{- $host := (.host | default (include "cells.nosql.host" .context)) -}}
{{- $port := (.port | default (include "cells.nosql.port" .context)) -}}
{{- $params := (.params | default ((include "cells.nosql.params" .context) | fromJson)) -}}
{{- $tlsParams := (.tlsParams | default ((include "cells.nosql.tls.params" .context) | fromJson)) -}}
{{- with .context -}}
{{- printf "%s://%s%s:%s/%s%s"
    $scheme
    $authParams
    $host
    $port
    $path
    (include "cells.urlQuery" (list $params $tlsParams))
}}
{{- end -}}
{{- end -}}
