{{/*
MARIADB HOST
*/}}
{{- define "cells.database.scheme" -}}
{{- if .Values.mariadb.enabled -}}
{{- printf "mysql" }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{- .Values.externalSQLDatabase.scheme }}
{{- end -}}
{{- end }}

{{- define "cells.database.host" -}}
{{- if .Values.mariadb.enabled -}}
{{- printf "%s-mariadb.%s.svc.%s" .Release.Name .Release.Namespace .Values.clusterDomain }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{- .Values.externalSQLDatabase.host }}
{{- end -}}
{{- end }}

{{/*
MARIADB PORT
*/}}
{{- define "cells.database.port" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.primary.service.ports.mysql | toString }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.port | toString }}
{{- end -}}
{{- end }}

{{/*
MARIADB PORT
*/}}
{{- define "cells.database.name" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.auth.database | toString }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.name | toString }}
{{- end -}}
{{- end }}

{{- define "cells.database.params" -}}
{{- range $k, $v := .Values.externalSQLDatabase.params -}}
{{- printf "%s=%s&" $k $v -}}
{{- end -}}
{{- end -}}

{{/*
MARIADB ACTIVATION
*/}}
{{- define "cells.database.enabled" -}}
{{- if or .Values.mariadb.enabled .Values.externalSQLDatabase.enabled -}}
{{ true }}
{{- end -}}
{{- end -}}

{{/*
MARIADB TLS ACTIVATION
*/}}
{{- define "cells.database.tls.enabled" -}}
{{- if and .Values.mariadb.enabled .Values.mariadb.tls.enabled -}}
{{- true -}}
{{- else if and .Values.externalSQLDatabase.enabled .Values.externalSQLDatabase.tls.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{- define "cells.database.tls.autoGenerated" -}}
{{- if and .Values.mariadb.enabled .Values.mariadb.tls.autoGenerated.enabled -}}
{{- true -}}
{{- else if and .Values.externalSQLDatabase.enabled .Values.externalSQLDatabase.tls.autoGenerated -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.database.tls.client.existingSecret" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.tls.existingSecret | default "cells-mariadb-crt" }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.tls.client.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.database.tls.client.cert" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.tls.certFilename | default "tls.crt" }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.tls.client.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.database.tls.client.key" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.tls.certKeyFilename | default "tls.key" }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.tls.client.key }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.database.tls.server.existingSecret" -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.database.tls.server.cert" -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.database.tls.server.key" -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.database.tls.ca.existingSecret" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.tls.existingSecret | default "cells-mariadb-crt" }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.tls.ca.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CA
*/}}
{{- define "cells.database.tls.ca.cert" -}}
{{- if .Values.mariadb.enabled -}}
{{ .Values.mariadb.tls.certCAFilename | default "ca.crt" }}
{{- else if .Values.externalSQLDatabase.enabled -}}
{{ .Values.externalSQLDatabase.tls.ca.cert }}
{{- end -}}
{{- end -}}

{{/*
MARIADB TLS PARAMÈTRES
*/}}
{{- define "cells.database.tls.params" -}}
{{- if (include "cells.database.tls.enabled" .) -}}
{{- include "cells.urlTLSParams" (dict
  "enabled"         (include "cells.database.tls.enabled" .)
  "prefix"          "mariadb"
  "certFilename"    (include "cells.database.tls.client.cert" .)
  "certKeyFilename" (include "cells.database.tls.client.key" .)
  "caFilename"      (include "cells.database.tls.ca.cert" .)
) -}}
{{- end -}}
{{- end -}}

{{/*
MARIADB AUTH ACTIVÉ
*/}}
{{- define "cells.database.auth.enabled" -}}
{{- if .Values.mariadb.enabled -}}
{{- true -}}
{{- else if and .Values.externalSQLDatabase.enabled .Values.externalSQLDatabase.auth.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
MARIADB USERNAME
*/}}
{{- define "cells.database.auth.user" -}}
{{- if .Values.mariadb.enabled -}}
{{- include "common.secrets.lookup" (dict "secret" .Values.mariadb.auth.existingSecret "key" "user" "context" . "defaultValue" "root") | b64dec -}}
{{- else -}}
{{- include "common.secrets.lookup" (dict "secret" .Values.externalSQLDatabase.auth.existingSecret "key" .Values.externalSQLDatabase.auth.existingSecretUsernameKey "context" . "defaultValue" .Values.externalSQLDatabase.auth.user) | b64dec -}}
{{- end -}}
{{- end -}}

{{/*
MARIADB PASSWORD
*/}}
{{- define "cells.database.auth.password" -}}
{{- if .Values.mariadb.enabled -}}
{{- include "common.secrets.lookup" (dict "secret" .Values.mariadb.auth.existingSecret "key" "mariadb-root-password" "context" . "defaultValue" .Values.mariadb.auth.rootPassword) | b64dec -}}
{{- else -}}
{{- include "common.secrets.lookup" (dict "secret" .Values.externalSQLDatabase.auth.existingSecret "key" .Values.externalSQLDatabase.auth.existingSecretPasswordKey "context" . "defaultValue" .Values.externalSQLDatabase.auth.password) | b64dec -}}
{{- end -}}
{{- end -}}

{{/*
MARIADB ENV SECRET
*/}}
{{- define "cells.database.auth.envvar" -}}
{{- if and (include "cells.database.auth.enabled" .) .Values.mariadb.enabled -}}
{{ $secret := .Values.mariadb.auth.existingSecret | default "cells-mariadb" }}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "DB_USERNAME" "value" (.Values.mariadb.auth.username | default "root")) }}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "DB_PASSWORD" "value" (dict "secretName" $secret "secretPasswordKey" "password")) }}
{{- else if and (include "cells.database.auth.enabled" .) .Values.externalSQLDatabase.auth.enabled -}}
{{- if empty .Values.externalSQLDatabase.auth.existingSecretUsernameKey -}}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "DB_USERNAME" "value" (.Values.externalSQLDatabase.auth.user | default "root")) }}
{{- else -}}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "DB_USERNAME" "value" (dict
  "secretName"        .Values.externalSQLDatabase.auth.existingSecret
  "secretPasswordKey" .Values.externalSQLDatabase.auth.existingSecretUsernameKey)) }}
{{- end }}
{{ if empty .Values.externalSQLDatabase.auth.existingSecretPasswordKey }}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "DB_PASSWORD" "value" .Values.externalSQLDatabase.auth.password) }}
{{- else -}}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "DB_PASSWORD" "value" (dict
  "secretName"        .Values.externalSQLDatabase.auth.existingSecret
  "secretPasswordKey" .Values.externalSQLDatabase.auth.existingSecretPasswordKey)) }}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
MARIADB URL UTILISATEUR
*/}}
{{- define "cells.database.auth.urlUser" -}}
{{ include "cells.urlUser" (dict
  "enabled"  (eq (include "cells.database.auth.enabled" .) "true")
  "user"     (include "cells.database.auth.user" .)
  "password" (include "cells.database.auth.password" .)
) }}
{{- end -}}

{{/*
MARIADB URL COMPLÈTE
*/}}
{{- define "cells.database.url" -}}
{{- $path := .path -}}
{{- $scheme := (.scheme | default (include "cells.database.scheme" .)) -}}
{{- $authParams := (.authParams | default (include "cells.database.auth.urlUser" .)) -}}
{{- $host := (.host | default (include "cells.database.host" .)) -}}
{{- $port := (.port | default (include "cells.database.port" .)) -}}
{{- $params := (.params | default (include "cells.database.params" .)) -}}
{{- $tlsParams := (.tlsParams | default (include "cells.database.tls.params" .)) -}}
{{- with .context }}
{{- printf "%s://%s%s:%s%s?%s&%s"
    $scheme
    $authParams
    $host
    $port
    $path
    $params
    $tlsParams
}}
{{- end }}
{{- end }}

{{/*
MARIADB URL COMPLÈTE
*/}}
{{- define "cells.database.dsn" -}}
{{- $path := .path -}}
{{- $scheme := (.scheme | default (include "cells.database.scheme" .context)) -}}
{{- $authParams := (.authParams | default (include "cells.database.auth.urlUser" .context)) -}}
{{- $host := (.host | default (include "cells.database.host" .context)) -}}
{{- $port := (.port | default (include "cells.database.port" .context)) -}}
{{- $params := (.params | default (include "cells.database.params" .context)) -}}
{{- $tlsParams := (.tlsParams | default (include "cells.database.tls.params" .context)) -}}
{{- printf "%s://%stcp(%s:%s)/%s?%s&%s"
    $scheme
    $authParams
    $host
    $port
    $path
    $params
    $tlsParams
}}
{{- end }}
