{{/*
REDIS HOST
*/}}
{{- define "cells.cache.scheme" -}}
{{- if .Values.redis.enabled -}}
{{- "redis" -}}
{{- else if .Values.externalCache.enabled -}}
{{- .Values.externalCache.scheme | default "redis" }}
{{- end -}}
{{- end }}

{{- define "cells.cache.host" -}}
{{- if .Values.redis.enabled -}}
{{- printf "%s-redis-master.%s.svc.%s" .Release.Name .Release.Namespace .Values.clusterDomain }}
{{- else if .Values.externalCache.enabled -}}
{{- .Values.externalCache.host }}
{{- end -}}
{{- end }}

{{/*
REDIS PORT
*/}}
{{- define "cells.cache.port" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.master.service.ports.redis | toString }}
{{- else if .Values.externalCache.enabled -}}
{{ .Values.externalCache.port | toString }}
{{- end -}}
{{- end }}

{{/*
REDIS ACTIVATION
*/}}
{{- define "cells.cache.enabled" -}}
{{- if or .Values.redis.enabled .Values.externalCache.enabled -}}
{{ true }}
{{- end -}}
{{- end -}}

{{- define "cells.cache.params" -}}
{{- .Values.externalCache.params | toJson }}
{{- end -}}


{{- define "cells.cache.envvar" -}}
{{- $authParams := (include "cells.urlUser" (dict "enabled" (include "cells.cache.auth.enabled" .) "user" "$CACHE_USERNAME" "password" "$CACHE_PASSWORD")) }}
{{- $cacheURL := (include "cells.cache.url" (dict "context" . "path" "cache" "authParams" $authParams)) -}}
{{- $shortcacheURL := (include "cells.cache.url" (dict "context" . "path" "shortcache" "authParams" $authParams)) -}}
{{- if (include "cells.cache.enabled" .) -}}
{{ include "common.tplvalues.render" (dict "value" (list (dict "name" "CELLS_CACHE" "value" $cacheURL)) "context" .) }}
{{- if .Values.redis.shortcacheEnabled -}}
{{ include "common.tplvalues.render" (dict "value" (list (dict "name" "CELLS_SHORTCACHE" "value" $shortcacheURL)) "context" .) }}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
REDIS TLS SCHEME
*/}}
{{- define "cells.cache.tls.scheme" -}}
{{ include "cells.urlTLSScheme" (dict "enabled" (eq (include "cells.cache.tls.enabled" .) "true") "scheme" "redis") }}
{{- end -}}

{{/*
REDIS TLS ACTIVATION
*/}}
{{- define "cells.cache.tls.enabled" -}}
{{- if and .Values.redis.enabled .Values.redis.tls.enabled -}}
{{- true -}}
{{- else if and .Values.externalCache.enabled .Values.externalCache.tls.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS ACTIVATION
*/}}
{{- define "cells.cache.tls.autoGenerated" -}}
{{- if and .Values.redis.enabled .Values.redis.tls.autoGenerated -}}
{{- true -}}
{{- else if and .Values.externalCache.enabled .Values.externalCache.tls.autoGenerated -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS EXISTING SECRET
*/}}
{{- define "cells.cache.tls.client.existingSecret" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.tls.existingSecret | default "cells-redis-crt" }}
{{- else if .Values.externalCache.enabled -}}
{{ .Values.externalCache.tls.client.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS CERTIFICATE
*/}}
{{- define "cells.cache.tls.client.cert" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.tls.certFilename | default "tls.crt" }}
{{- else if .Values.externalCache.enabled -}}
{{ .Values.externalCache.tls.client.cert }}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS CLÉ PRIVÉE
*/}}
{{- define "cells.cache.tls.client.key" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.tls.certKeyFilename | default "tls.key" }}
{{- else if .Values.externalCache.enabled -}}
{{ .Values.externalCache.tls.client.key }}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS EXISTING SECRET
*/}}
{{- define "cells.cache.tls.server.existingSecret" -}}
{{- end -}}

{{/*
CACHE TLS CERTIFICATE
*/}}
{{- define "cells.cache.tls.server.cert" -}}
{{- end -}}

{{/*
CACHE TLS CLÉ PRIVÉE
*/}}
{{- define "cells.cache.tls.server.key" -}}
{{- end -}}

{{/*
CACHE TLS EXISTING SECRET
*/}}
{{- define "cells.cache.tls.ca.existingSecret" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.tls.existingSecret | default "cells-redis-crt" }}
{{- else if .Values.externalCache.enabled -}}
{{ .Values.externalCache.tls.ca.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS CA
*/}}
{{- define "cells.cache.tls.ca.cert" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.tls.certCAFilename | default "ca.crt" }}
{{- else if .Values.externalCache.enabled -}}
{{ .Values.externalCache.tls.ca.cert }}
{{- end -}}
{{- end -}}

{{/*
CACHE TLS PARAMÈTRES
*/}}
{{- define "cells.cache.tls.params" -}}
{{ if (include "cells.cache.tls.enabled" .) }}
{{- include "cells.urlTLSParamsDict" (dict
  "enabled"         (include "cells.cache.tls.enabled" .)
  "prefix"          "cache"
  "certFilename"    (include "cells.cache.tls.client.cert" .)
  "certKeyFilename" (include "cells.cache.tls.client.key" .)
  "caFilename"      (include "cells.cache.tls.ca.cert" .)
) -}}
{{- else -}}
{{- "{}" -}}
{{- end -}}
{{- end -}}

{{/*
CACHE AUTH ACTIVÉ
*/}}
{{- define "cells.cache.auth.enabled" -}}
{{- if and .Values.redis.enabled .Values.redis.auth.enabled -}}
{{- true -}}
{{- else if and .Values.externalCache.enabled .Values.externalCache.auth.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
CACHE USERNAME
*/}}
{{- define "cells.cache.auth.user" -}}
{{- if .Values.redis.enabled -}}
{{ .Values.redis.auth.username }}
{{- else if .Values.externalCache.enabled -}}
{{- include "common.secrets.lookup" (dict "secret" .Values.externalCache.auth.existingSecret "key" .Values.externalCache.auth.existingSecretUserKey "context" . "defaultValue" .Values.externalCache.auth.user) | b64dec -}}
{{- end -}}
{{- end -}}

{{/*
CACHE PASSWORD
*/}}
{{- define "cells.cache.auth.password" -}}
{{- if .Values.redis.enabled -}}
{{ "$(REDIS_PASSWORD)" }}
{{- else if .Values.externalCache.enabled -}}
{{- include "common.secrets.lookup" (dict "secret" .Values.externalCache.auth.existingSecret "key" .Values.externalCache.auth.existingSecretPasswordKey "context" . "defaultValue" .Values.externalCache.auth.password) | b64dec -}}
{{- end -}}
{{- end -}}

{{/*
CACHE ENV SECRET (password)
*/}}
{{- define "cells.cache.auth.envvar" -}}
{{- if and (include "cells.cache.auth.enabled" .) .Values.redis.enabled }}
{{- include "cells.tplvalues.renderSecretPassword" (dict "name" "REDIS_PASSWORD" "value" .Values.redis.auth.password) }}
{{- else if and (include "cells.cache.auth.enabled" .) .Values.externalCache.auth.enabled -}}
{{- include "cells.auth.envvar" (dict "auth" .Values.externalCache.auth "prefix" "CACHE") }}
{{- end -}}
{{- end -}}

{{/*
CACHE URL UTILISATEUR
*/}}
{{- define "cells.cache.auth.urlUser" -}}
{{ include "cells.urlUser" (dict
  "enabled"  (include "cells.cache.auth.enabled" .)
  "user"     (include "cells.cache.auth.user" .)
  "password" (include "cells.cache.auth.password" .)
) }}
{{- end -}}

{{/*
CACHE URL COMPLÈTE
*/}}
{{- define "cells.cache.url" -}}
{{- $path := .path -}}
{{- $scheme := (.scheme | default (include "cells.cache.scheme" .context)) -}}
{{- $authParams := .authParams -}}
{{- $host := (.host | default (include "cells.cache.host" .context)) -}}
{{- $port := (.port | default (include "cells.cache.port" .context)) -}}
{{- $params := (merge ((include "cells.cache.params" .context) | fromJson) (.params | default)) -}}
{{- $tlsParams := (merge ((include "cells.cache.tls.params" .context) | fromJson) (.tlsParams | default)) -}}
{{- with .context -}}
{{- printf "%s://%s%s:%s/%s%s"
    $scheme
    $authParams
    $host
    $port
    $path
    (include "cells.urlQuery" (list $params $tlsParams))
}}
{{- end -}}
{{- end }}
