{{/*
ETCD HOST
*/}}
{{- define "cells.discovery.scheme" -}}
{{- if .Values.etcd.enabled -}}
{{- "etcd" -}}
{{- else if .Values.externalDiscovery.enabled -}}
{{- .Values.externalDiscovery.scheme | default "etcd" }}
{{- end -}}
{{- end }}

{{- define "cells.discovery.host" -}}
{{- if .Values.etcd.enabled }}
{{- printf "%s-etcd.%s.svc.%s" .Release.Name .Release.Namespace .Values.clusterDomain }}
{{- else if .Values.externalDiscovery.enabled -}}
{{- .Values.externalDiscovery.host | toString }}
{{- end -}}
{{- end }}

{{- define "cells.discovery.port" -}}
{{- if .Values.etcd.enabled }}
{{- .Values.etcd.service.ports.client | toString }}
{{- else if .Values.externalDiscovery.enabled -}}
{{- .Values.externalDiscovery.port | toString }}
{{- end -}}
{{- end }}

{{- define "cells.discovery.enabled" -}}
{{- if or .Values.etcd.enabled .Values.externalDiscovery.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.params" -}}
{{- .Values.externalDiscovery.params | toJson }}
{{- end -}}

{{- define "cells.discovery.envvar" -}}
{{- if (include "cells.discovery.enabled" .) -}}
{{- $authParams := (include "cells.urlUser" (dict "enabled" (include "cells.discovery.auth.enabled" .) "user" "$DISCOVERY_USERNAME" "password" "$DISCOVERY_PASSWORD")) }}
{{- $configURL := (include "cells.discovery.url" (dict "context" . "path" "config" "authParams" $authParams)) -}}
{{- $vaultURL := (include "cells.discovery.url" (dict "context" . "path" "vault" "authParams" $authParams)) -}}
{{- $registryURL := (include "cells.discovery.url" (dict "context" . "path" "registry" "authParams" $authParams)) -}}
{{ include "common.tplvalues.render" (dict "value" (list (dict "name" "CELLS_CONFIG" "value" $configURL)) "context" .) }}
{{ include "common.tplvalues.render" (dict "value" (list (dict "name" "CELLS_VAULT" "value" $vaultURL)) "context" .) }}
{{ include "common.tplvalues.render" (dict "value" (list (dict "name" "CELLS_REGISTRY" "value" $registryURL)) "context" .) }}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.tls.scheme" -}}
{{ include "cells.urlTLSScheme" (dict "enabled" (eq (include "cells.discovery.tls.enabled" .) "true") "scheme" "etcd")}}
{{- end -}}

{{- define "cells.discovery.tls.enabled" -}}
{{- if and .Values.etcd.enabled .Values.etcd.auth.client.secureTransport -}}
{{- true -}}
{{- else if and .Values.externalDiscovery.enabled .Values.externalDiscovery.tls.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS ACTIVATION
*/}}
{{- define "cells.discovery.tls.autoGenerated" -}}
{{- if and .Values.etcd.enabled .Values.etcd.auth.client.secureTransport .Values.etcd.auth.client.useAutoTLS -}}
{{- true -}}
{{- else if and .Values.externalDiscovery.enabled .Values.externalDiscovery.tls.enabled .Values.externalDiscovery.tls.autoGenerated -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.discovery.tls.client.existingSecret" -}}
{{- if .Values.etcd.enabled -}}
{{ .Values.etcd.auth.client.existingSecret | default "cells-etcd-crt" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.client.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.discovery.tls.client.cert" -}}
{{- if .Values.etcd.enabled -}}
{{ .Values.etcd.auth.client.certFilename | default "tls.crt" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.client.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.discovery.tls.client.key" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.etcd.auth.client.certKeyFilename | default "tls.key" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.client.key }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.discovery.tls.server.existingSecret" -}}
{{- if .Values.etcd.enabled -}}
{{ .Values.etcd.auth.client.existingSecret | default "cells-etcd-crt" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.server.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.discovery.tls.server.cert" -}}
{{- if .Values.etcd.enabled -}}
{{ "tls.crt" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.server.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.discovery.tls.server.key" -}}
{{- if .Values.etcd.enabled -}}
{{ "tls.key" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.server.key }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.discovery.tls.ca.existingSecret" -}}
{{- if .Values.etcd.enabled -}}
{{ .Values.etcd.auth.client.existingSecret | default "cells-etcd-crt" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.ca.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CA
*/}}
{{- define "cells.discovery.tls.ca.cert" -}}
{{- if .Values.etcd.enabled -}}
{{ .Values.etcd.auth.client.caFilename | default "tls.crt" }}
{{- else if .Values.externalDiscovery.enabled -}}
{{ .Values.externalDiscovery.tls.ca.cert }}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.tls.params" -}}
{{- if (include "cells.discovery.tls.enabled" .) -}}
{{- include "cells.urlTLSParamsDict" (dict "enabled" (include "cells.discovery.tls.enabled" .) "insecure" (empty (include "cells.discovery.tls.client.existingSecret" .)) "prefix" "etcd" "certFilename" (include "cells.discovery.tls.client.cert" .) "certKeyFilename" (include "cells.discovery.tls.client.key" .) "caFilename" (include "cells.discovery.tls.ca.cert" .)) -}}
{{- else -}}
{{- "{}" -}}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.auth.enabled" -}}
{{- if and .Values.etcd.enabled .Values.etcd.auth.rbac.create -}}
{{- true -}}
{{- else if and .Values.externalDiscovery.enabled .Values.externalDiscovery.auth.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.auth.user" -}}
{{- if and (include "cells.discovery.auth.enabled" .) .Values.etcd.enabled -}}
{{ "root" }}
{{- else if and (include "cells.discovery.auth.enabled" .) .Values.externalDiscovery.enabled -}}
{{- (include "common.secrets.lookup" (dict "secret" .Values.externalDiscovery.auth.existingSecret "key" (.Values.externalDiscovery.auth.existingSecretUserKey | default "") "context" . "defaultValue" (.Values.externalDiscovery.auth.user | default "root"))) | b64dec -}}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.auth.password" -}}
{{- if include "cells.discovery.auth.enabled" . -}}
{{- if .Values.externalDiscovery.enabled }}
{{- (include "common.secrets.lookup" (dict "secret" .Values.externalDiscovery.auth.existingSecret "key" (.Values.externalDiscovery.auth.existingSecretPasswordKey | default "") "context" . "defaultValue" .Values.externalDiscovery.auth.password)) | b64dec -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.auth.envvar" -}}
{{- if and (include "cells.discovery.auth.enabled" .) .Values.etcd.enabled -}}
{{- include "cells.tplvalues.renderSecretPassword" (dict "name" "DISCOVERY_ROOT_PASSWORD" "value" (index (index .Values.nats.auth.credentials 0) "password")) }}
{{- else if and (include "cells.discovery.auth.enabled" .) .Values.externalDiscovery.auth.enabled -}}
{{- include "cells.auth.envvar" (dict "auth" .Values.externalDiscovery.auth "prefix" "DISCOVERY") }}
{{- end -}}
{{- end -}}

{{- define "cells.discovery.auth.urlUser" -}}
{{ include "cells.urlUser" (dict
  "enabled" (include "cells.discovery.auth.enabled" .)
  "user" (include "cells.discovery.auth.user" .)
  "password" (include "cells.discovery.auth.password" .)) }}
{{- end -}}

{{- define "cells.discovery.url" -}}
{{- $path := .path -}}
{{- $scheme := (.scheme | default (include "cells.discovery.scheme" .context)) -}}
{{- $authParams := (.authParams | default (include "cells.discovery.auth.urlUser" .context)) -}}
{{- $host := (.host | default (include "cells.discovery.host" .context)) -}}
{{- $port := (.port | default (include "cells.discovery.port" .context)) -}}
{{- $params := (.params | default ((include "cells.discovery.params" .context) | fromJson)) -}}
{{- $tlsParams := (.tlsParams | default ((include "cells.discovery.tls.params" .context) | fromJson) | default) -}}
{{- with .context -}}
{{- printf "%s://%s%s:%s/%s%s"
    $scheme
    $authParams
    $host
    $port
    $path
    (include "cells.urlQuery" (list $params $tlsParams))
}}
{{- end -}}
{{- end }}