{{/*
NATS HOST
*/}}
{{- define "cells.broker.scheme" -}}
{{- if .Values.nats.enabled -}}
{{- "nats" -}}
{{- else if .Values.externalBroker.enabled -}}
{{- .Values.externalBroker.scheme | default "nats" }}
{{- end -}}
{{- end }}

{{- define "cells.broker.host" -}}
{{- if .Values.nats.enabled -}}
{{- printf "%s-nats.%s.svc.%s" .Release.Name .Release.Namespace .Values.clusterDomain }}
{{- else if .Values.externalBroker.enabled -}}
{{- .Values.externalBroker.host }}
{{- end -}}
{{- end }}

{{/*
NATS PORT
*/}}
{{- define "cells.broker.port" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.service.ports.client | toString }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.port | toString }}
{{- end -}}
{{- end }}

{{/*
NATS ACTIVATION
*/}}
{{- define "cells.broker.enabled" -}}
{{- if or .Values.nats.enabled .Values.externalBroker.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{- define "cells.broker.params" -}}
{{- if .Values.externalBroker.enabled -}}
{{- $array := .Values.externalBroker.params -}}
{{- if not (empty .Values.externalBroker.auth.existingSecretServerConf) }}
{{- $array = merge $array (dict "serverConfEnv" "BROKER_SERVER_CONF") -}}
{{- end -}}
{{- $array | toJson -}}
{{- end -}}
{{- end -}}

{{- define "cells.broker.envvar" -}}
{{- if (include "cells.broker.enabled" .) -}}
{{- $enabled := (and .Values.externalBroker.auth.enabled (empty .Values.externalBroker.auth.existingSecretServerConf)) -}}
{{ include "common.tplvalues.render" (dict "value" (list (
    dict
        "name" "CELLS_BROKER"
        "value" (include "cells.broker.url" (dict "context" . "path" "cells" "authParams" (include "cells.urlUser" (dict "enabled" $enabled "user" "$BROKER_USERNAME" "password" "$BROKER_PASSWORD")) ))
    )) "context" .) }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS SCHEME
*/}}
{{- define "cells.broker.tls.scheme" -}}
{{ "nats" }}
{{- end -}}

{{/*
NATS TLS ACTIVATION
*/}}
{{- define "cells.broker.tls.enabled" -}}
{{- if and .Values.nats.enabled .Values.nats.tls.enabled -}}
{{- true -}}
{{- else if and .Values.externalBroker.enabled .Values.externalBroker.tls.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS ACTIVATION
*/}}
{{- define "cells.broker.tls.autoGenerated" -}}
{{- if and .Values.nats.enabled .Values.nats.tls.autoGenerated -}}
{{- true -}}
{{- else if and .Values.externalBroker.enabled .Values.externalBroker.tls.autoGenerated -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.broker.tls.client.existingSecret" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.client.existingSecret | default "cells-nats-client-crt" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.client.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.broker.tls.client.cert" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.client.cert | default "tls.crt" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.client.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.broker.tls.client.key" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.client.key | default "tls.key" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.client.key }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.broker.tls.server.existingSecret" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.server.existingSecret | default "cells-nats-crt" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.server.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CERTIFICATE
*/}}
{{- define "cells.broker.tls.server.cert" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.server.cert | default "tls.crt" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.server.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CLÉ PRIVÉE
*/}}
{{- define "cells.broker.tls.server.key" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.server.key | default "tls.key" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.server.key }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS EXISTING SECRET
*/}}
{{- define "cells.broker.tls.ca.existingSecret" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.existingCASecret | default "cells-nats-ca-crt" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.ca.existingSecret }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS CA
*/}}
{{- define "cells.broker.tls.ca.cert" -}}
{{- if .Values.nats.enabled -}}
{{ .Values.nats.tls.ca | default "tls.crt" }}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.tls.ca.cert }}
{{- end -}}
{{- end -}}

{{/*
NATS TLS PARAMÈTRES URL
*/}}
{{- define "cells.broker.tls.params" -}}
{{- if (include "cells.broker.tls.enabled" .) -}}
{{- include "cells.urlTLSParamsDict" (dict
  "enabled" (include "cells.broker.tls.enabled" .)
  "prefix" "broker"
  "certFilename" (include "cells.broker.tls.client.cert" .)
  "certKeyFilename" (include "cells.broker.tls.client.key" .)
  "caFilename" (include "cells.broker.tls.ca.cert" .)
) -}}
{{- else -}}
{{ "{}" }}
{{- end -}}
{{- end -}}

{{/*
NATS AUTH ACTIVÉ
*/}}
{{- define "cells.broker.auth.enabled" -}}
{{- if and .Values.nats.enabled .Values.nats.auth.enabled -}}
{{- true -}}
{{- else if and .Values.externalBroker.enabled .Values.externalBroker.auth.enabled -}}
{{- true -}}
{{- end -}}
{{- end -}}

{{/*
NATS CREDENTIALS
*/}}
{{- define "cells.broker.auth.credentials" -}}
{{- if .Values.nats.enabled -}}
{{- (index .Values.nats.auth.credentials 0) | toJson -}}
{{- else if .Values.externalBroker.enabled -}}
{{ .Values.externalBroker.auth.user }}
  {{- .Values.nats.auth.credentials | toJson -}}
{{- end -}}
{{- end -}}

{{/*
NATS USERNAME
{{ (index ((include "cells.broker.auth.credentials" .) | fromYaml) "user") | default "" | toString }}

*/}}
{{- define "cells.broker.auth.user" -}}
{{- if and (include "cells.broker.auth.enabled" .) .Values.nats.enabled -}}
{{ "$NATS_USER" }}
{{- else if and (include "cells.broker.auth.enabled" .) .Values.externalBroker.auth.enabled -}}
{{- $data := include "common.secrets.lookup" (dict "secret" .Values.externalBroker.auth.existingSecret "key" .Values.externalBroker.auth.existingSecretUserKey "context" . "defaultValue" .Values.externalBroker.auth.user) | b64dec -}}
{{- regexFind "user: \"[^\"]*\"" $data | trimPrefix "user: \"" | trimSuffix "\"" | toString -}}
{{- end -}}
{{- end -}}

{{/*
NATS PASSWORD (masqué)
*/}}
{{- define "cells.broker.auth.password" -}}
{{- if and (include "cells.broker.auth.enabled" .) .Values.nats.enabled -}}
{{ "$NATS_PASSWORD" }}
{{- else if and (include "cells.broker.auth.enabled" .) .Values.externalBroker.auth.enabled -}}
{{- $data := include "common.secrets.lookup" (dict "secret" .Values.externalBroker.auth.existingSecret "key" .Values.externalBroker.auth.existingSecretPasswordKey "context" . "defaultValue" .Values.externalBroker.auth.user) | b64dec -}}
{{- regexFind "password: \"[^\"]*\"" $data | trimPrefix "password: \"" | trimSuffix "\"" | toString -}}
{{- end -}}
{{- end -}}

{{/*
NATS SECRET D'ENV (rend le mot de passe dans un secret)
"secretName" (index $credentials "existingSecret")
*/}}
{{- define "cells.broker.auth.envvar" -}}
{{- if .Values.nats.enabled -}}
{{- $secret := .Values.nats.auth.existingSecret | default "cells-nats" -}}
{{- include "cells.tplvalues.renderSecretPassword" (dict "name" "BROKER_USERNAME" "value" (.Values.nats.auth.username | default "root")) -}}
{{- include "cells.tplvalues.renderSecretPassword" (dict "name" "BROKER_PASSWORD" "value" (dict "secretName" $secret "secretPasswordKey" "password")) -}}
{{- else if .Values.externalBroker.auth.enabled -}}
{{- if empty .Values.externalBroker.auth.existingSecretServerConf -}}
{{- include "cells.auth.envvar" (dict "auth" .Values.externalBroker.auth "prefix" "BROKER") }}
{{- else -}}
{{- $secret := .Values.externalBroker.auth.existingSecret | default "cells-nats" -}}
{{- include "common.tplvalues.render" (dict "value" (list (dict "name" "NATS_SERVER_NAME" "value" "mock"))) }}
{{ include "cells.tplvalues.renderSecretPassword" (dict "name" "BROKER_SERVER_CONF" "value" (dict "secretName" $secret "secretPasswordKey" .Values.externalBroker.auth.existingSecretServerConf)) -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
NATS AUTH URL (username:password@)
*/}}
{{- define "cells.broker.auth.urlUser" -}}
{{ include "cells.urlUser" (dict
  "enabled" (include "cells.broker.auth.enabled" .)
  "user" (include "cells.broker.auth.user" .)
  "password" (include "cells.broker.auth.password" .)
) }}
{{- end -}}

{{/*
NATS COMPLETE URL
*/}}
{{- define "cells.broker.url" -}}
{{- $path := .path -}}
{{- $scheme := (.scheme | default (include "cells.broker.scheme" .context)) -}}
{{- $authParams := .authParams -}}
{{- $host := (.host | default (include "cells.broker.host" .context)) -}}
{{- $port := (.port | default (include "cells.broker.port" .context)) -}}
{{- $params := (.params | default ((include "cells.broker.params" .context) | fromJson)) -}}
{{- $tlsParams := (.tlsParams | default ((include "cells.broker.tls.params" .context) | fromJson)) -}}
{{- with .context -}}
{{- printf "%s://%s%s:%s/%s%s"
    $scheme
    $authParams
    $host
    $port
    $path
    (include "cells.urlQuery" (list $params $tlsParams))
}}
{{- end -}}
{{- end -}}
