{{/*
Copyright Broadcom, Inc. All Rights Reserved.
SPDX-License-Identifier: APACHE-2.0
*/}}

{{/* vim: set filetype=mustache: */}}

{{/*
Return the proper NATS image name
*/}}
{{- define "nats.image" -}}
{{ include "common.images.image" (dict "imageRoot" .Values.image "global" .Values.global) }}
{{- end -}}

{{/*
Return the proper image name (for the metrics image)
*/}}
{{- define "nats.metrics.image" -}}
{{ include "common.images.image" (dict "imageRoot" .Values.metrics.image "global" .Values.global) }}
{{- end -}}

{{/*
Return the proper Docker Image Registry Secret Names
*/}}
{{- define "nats.imagePullSecrets" -}}
{{- include "common.images.pullSecrets" (dict "images" (list .Values.image .Values.metrics.image) "global" .Values.global) -}}
{{- end -}}

{{/*
Create a random alphanumeric password string.
We prepend a random letter to the string to avoid password validation errors
*/}}
{{- define "nats.randomPassword" -}}
{{- randAlpha 1 -}}{{- randAlphaNum 9 -}}
{{- end -}}

{{/*
Create the name of the service account to use
*/}}
{{- define "nats.serviceAccountName" -}}
{{- if .Values.serviceAccount.create -}}
    {{ default (include "common.names.fullname" .) .Values.serviceAccount.name }}
{{- else -}}
    {{ default "default" .Values.serviceAccount.name }}
{{- end -}}
{{- end -}}

{{/*
Return the NATS configuration secret name
*/}}
{{- define "nats.secretName" -}}
{{ default (include "common.names.fullname" .) (tpl .Values.existingSecret .) -}}
{{- end -}}

{{/*
Return the name of the secret containing the CA TLS certificate
*/}}
{{- define "nats.tls.ca.secretName" -}}
{{- if or .Values.tls.autoGenerated.enabled (and (not (empty .Values.tls.ca))) -}}
    {{- printf "%s-ca-crt" (include "common.names.fullname" .) -}}
{{- else -}}
    {{- required "An existing secret name must be provided with a CA cert for NATS if cert is not provided!" (tpl .Values.tls.existingCASecret .) -}}
{{- end -}}
{{- end -}}

{{/*
Return the name of the secret containing the TLS certificates for NATS servers
*/}}
{{- define "nats.tls.server.secretName" -}}
{{- if or .Values.tls.autoGenerated.enabled (and (not (empty .Values.tls.server.cert)) (not (empty .Values.tls.server.key))) -}}
    {{- printf "%s-crt" (include "common.names.fullname" .) -}}
{{- else -}}
    {{- required "An existing secret name must be provided with TLS certs for NATS servers if cert and key are not provided!" (tpl .Values.tls.server.existingSecret .) -}}
{{- end -}}
{{- end -}}

{{/*
Return the name of the secret containing the TLS certificates for NATS clients
*/}}
{{- define "nats.tls.client.secretName" -}}
{{- if or .Values.tls.autoGenerated.enabled (and (not (empty .Values.tls.client.cert)) (not (empty .Values.tls.client.key))) -}}
    {{- printf "%s-client-crt" (include "common.names.fullname" .) -}}
{{- else -}}
    {{- required "An existing secret name must be provided with TLS certs for NATS clients if cert and key are not provided!" (tpl .Values.tls.client.existingSecret .) -}}
{{- end -}}
{{- end -}}

{{/*
Compile all warnings into a single message, and call fail.
*/}}
{{- define "nats.validateValues" -}}
{{- $messages := list -}}
{{- $messages := append $messages (include "nats.validateValues.resourceType" .) -}}
{{- $messages := append $messages (include "nats.validateValues.jetstream" .) -}}
{{- $messages := without $messages "" -}}
{{- $message := join "\n" $messages -}}

{{- if $message -}}
{{-   printf "\nVALUES VALIDATION:\n%s" $message | fail -}}
{{- end -}}
{{- end -}}

{{/* Validate values of NATS - must provide a valid resourceType ("deployment" or "statefulset") */}}
{{- define "nats.validateValues.resourceType" -}}
{{- if and (ne (lower .Values.resourceType) "deployment") (ne (lower .Values.resourceType) "statefulset") -}}
nats: resourceType
    Invalid resourceType selected. Valid values are "deployment" and
    "statefulset". Please set a valid mode (--set resourceType="xxxx")
{{- end -}}
{{- end -}}

{{/* Validate values of NATS - enabling JetStream requires persistence & StatefulSet */}}
{{- define "nats.validateValues.jetstream" -}}
{{- if and .Values.jetstream.enabled (or (ne .Values.resourceType "statefulset") (not .Values.persistence.enabled)) -}}
nats: jetstream
    Invalid configuration selected. Enabling JetStream requires enabling persistence
    and using a StatefulSet (--set persistence.enabled=true,resourceType="statefulset")
{{- end -}}
{{- end -}}
