# Pydio Cells - Enterprise Distribution 

This is a Pydio Virtual Appliance based on the Rocky Linux 9, packaged with a maximum of features ready to work out of the box.
Pydio Cells Enterprise: 4.9.92-alpha11
OS: Rocky Linux 9 64bits

## Hardware requirements

- CPU support VT-x/ADM-V
- RAM 4GB

## Quickstart 

1. Import image file in VirtualBox, configure network
2. Launch the machine 
3. Access to Cells Enterprise end-user interface by browsing to: https://ipaddress/
4. Follow the steps from the installer to configuration of your instance. All parameters are already setup with default values.
5. Let the installation terminate, and after a few minutes, you should be ready to go.

## Accounts and users

By default, all passwords are set to `cells`.

The appliance has 3 default user:

- root: the root user, you should not normally use this
- sysadmin: a system administrator that has sudo rights on all commands without password
- pydio: used to run the app. *Always* use this account when interracting with the `cells` command directly (see #Useful commands below).

## File System

All default configuration and data can be found under `/var/cells` that is exported as `CELLS_WORKING_DIR` for pydio user.
Here is an overview of the important files :

- `/var/cells/pydio.json`: main configuration file
- `/var/cells/data`: the data (a.k.a your files)
- `/var/cells/logs`: the application logs
- `/var/cells/services`: services information
- `/var/cells/certs`: certificate management

## Useful commands

### Check Cells Version 

```sh
cells version
```

### Manage your URLs and corresponding TLS configurations

To manage how Cells is binding to network interfaces and how it is exposed to outside world, use this command:

```sh
cells configure sites
```

This is the main tool for listing, editing, adding and removing URLs. Additional sub-commands allow you to directly create/delete sites.
  
Each site has following parameters:

1. **Bind Host(s)**: one or more <ip/hostname:port> to hook the internal webserver to. 
2. **TLS Settings**: TLS configuration for HTTPS support.
3. **External URL**: the URL you communicate to your end-users. It can differ from your bind address, 
      typically if the app is behind a reverse-proxy or inside a container with ports mapping.
4. **Maintenance Mode**: [On|Off] toggle to expose a maintenance page on this endpoint, although Cells is running.
